unit IdSysLog2;

interface
uses Classes, IdAssignedNumbers, IdUDPBase, IdUDPClient;

type
  TPriorityCode = pcEmerg, {0 - emergency - system unusable}
                  pcUrgent, {1 - action must be taken immediately }
                  pcCrit, { 2 - critical conditions }
                  pcError, {3 - error conditions }
                  pcWarning, {4 - warning conditions }
                  pcNormal, {5 - normal but signification condition }
                  pcInformational, {6 - informational }
                  pcDebug; {7 - debug-level messages }

  TIdSysLog = class(TIdUDPClient)
  public
    constructor Creat(AOwner : TComponent); override;
  published
    property Port default IdPORT_syslog;
  end;

implementation

///*
// *  Facility codes
// */

const
//#define LOG_KERN	(0<<3)	/* kernel messages */
  LOG_KERN = 0 SHL 3;
//#define LOG_USER	(1<<3)	/* random user-level messages */
  LOG_USER = 1 SHL 3;
//#define LOG_MAIL	(2<<3)	/* mail system */
  LOG_MAIL = 2 SHL 3;
//#define LOG_DAEMON	(3<<3)	/* system daemons */
  LOG_DAEMON = 3 SHL 3;
//#define LOG_AUTH	(4<<3)	/* security/authorization messages */
  LOG_AUTH   = 4 SHL 3;
//#define LOG_SYSLOG	(5<<3)	/* messages generated internally by syslogd */
  LOG_SYSLOG = 5 SHL 3;
//#define LOG_LPR		(6<<3)	/* line printer subsystem */
  LOG_LPR    = 6 SHL 3;
//#define LOG_NEWS	(7<<3)	/* network news subsystem */
  LOG_NEWS   = 7 SHL 3;
//#define LOG_UUCP	(8<<3)	/* UUCP subsystem */
  LOG_UUCP   = 8 SHL 3;
 //	/* other codes through 15 reserved for system use */
//#define LOG_LOCAL0	(16<<3)	/* reserved for local use */
  LOG_LOCAL0 = 16 SHL 3;
//#define LOG_LOCAL1	(17<<3)	/* reserved for local use */
  LOG_LOCAL1 = 17 SHL 3;
//#define LOG_LOCAL2	(18<<3)	/* reserved for local use */
  LOG_LOCAL2 = 18 SHL 3;
//#define LOG_LOCAL3	(19<<3)	/* reserved for local use */
  LOG_LOCAL3 = 19 SHL 3;
//#define LOG_LOCAL4	(20<<3)	/* reserved for local use */
  LOG_LOCAL4 = 20 SHL 3;
//#define LOG_LOCAL5	(21<<3)	/* reserved for local use */
  LOG_LOCAL5 = 21 SHL 3;
//#define LOG_LOCAL6	(22<<3)	/* reserved for local use */
  LOG_LOCAL6 = 22 SHL 3;
//#define LOG_LOCAL7	(23<<3)	/* reserved for local use */
  LOG_LOCAL7 = 23 SHL 3;

//#define LOG_NFACILITIES	24	/* maximum number of facilities */
  LOG_NFACILITIES   =	24;
//#define LOG_FACMASK	0x03f8	/* mask to extract facility part */
  LOG_FACMASK       = $03f8;

// LOG_FAC(p)	(((p) & LOG_FACMASK) >> 3)
Function LogFacility(AValue : Word) : Word;
begin
  Result := AValue and LOG_FACMASK;
end;

const
///*
// *  Priorities (these are ordered)
// */

//#define LOG_EMERG	0	/* system is unusable */
  LOG_EMERG         = 0;
//#define LOG_ALERT	1	/* action must be taken immediately */
  LOG_ALERT         = 1;
//#define LOG_CRIT	2	/* critical conditions */
  LOG_CRIT          = 2;
//#define LOG_ERR		3	/* error conditions */
  LOG_ERR           = 3;
//#define LOG_WARNING	4	/* warning conditions */
  LOG_WARNING       = 4;
//#define LOG_NOTICE	5	/* normal but signification condition */
  LOG_NOTICE        = 5;
//#define LOG_INFO	6	/* informational */
  LOG_INFO          = 6;
//#define LOG_DEBUG	7	/* debug-level messages */
  LOG_DEBUG         = 7;
//#define LOG_PRIMASK	0x0007	/* mask to extract priority part (internal) */
  LOG_PRIMASK       = $0007;
//#define LOG_PRI(p)	((p) & LOG_PRIMASK)	/* extract priority */

function LogPriority(AValue : Word); Word;
begin
  Result := AValue and LOG_PRIMASK;
end;

{ TIdSysLog }

constructor TIdSysLog.Creat(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Port := IdPORT_syslog;
end;

end.
