unit IdSNPP;

interface
uses
  Classes,
  IdException,
  IdGlobal,
  IdTCPConnection,
  IdMessage,
  IdComponent,
  IdMessageClient;

{
  Simple Network Paging Protocol based on RFC 1861
  Original Author: Mark Holmes

  I'll put the resource strings in later.
}

type
  TConnectionResult = (crCanPost, crNoPost, crAuthRequired, crTempUnavailable);
  TCheckResp = Record
    Code : SmallInt;
    Resp : String;
  end;

  TIdSNPP = class (TIdMessageClient)
  private
    function Pager(APagerId: String): Boolean;
    function SNPPMsg(AMsg: String): Boolean;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Reset;
    function SendMessage(APagerId,AMsg: String): String;
    procedure Help;
    procedure Quit;
    procedure Data;
    procedure Login(AUser, APassword : String);
    procedure HoldUntil (ADate: TDateTime);
    procedure CallerId(ACaller : String);
    procedure MCResponse;
    procedure MStatus;
    procedure Connect(const ATimeout: Integer = IdTimeoutDefault); override;
    procedure Disconnect; override;
  published
    property Port default 7777;
  end;

  EIdSNPPException = class(EIdException);
  EIdSNPPConnectionRefused = class (EIdProtocolReplyError);
  EIdSNPPProtocolError = class (EIdProtocolReplyError);
implementation


{ TIdSNPP }

constructor TIdSNPP.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Port := 7777;
end;

procedure TIdSNPP.CallerId(ACaller: String);
begin
 //
end;

procedure TIdSNPP.Connect(const ATimeout: Integer = IdTimeoutDefault);
var
  Resp : String;
begin
  inherited Connect(ATimeout);
  try
    Resp := Copy(CmdResult, 5, Maxint);
    GetResponse([]);
    if not ResultNo = 220 then
      raise EIdSNPPConnectionRefused.CreateError(502,Resp);
  except
    Disconnect;
    Raise;
  end;
end;

procedure TIdSNPP.Data;
begin
  //
end;

procedure TIdSNPP.Disconnect;
begin
  inherited;

end;

procedure TIdSNPP.Help;
begin
 //
end;

procedure TIdSNPP.HoldUntil(ADate: TDateTime);
begin
 //
end;

procedure TIdSNPP.Login(AUser, APassword: String);
begin
 //
end;

procedure TIdSNPP.MCResponse;
begin
 //
end;

procedure TIdSNPP.MStatus;
begin
 //
end;

function TIdSNPP.Pager(APagerId: String): Boolean;
begin
  Result := False;
  Writeln('PAGER ' + APagerID);
  if GetResponse([]) = 250 then
    Result := True
  else
    DoStatus(hsStatusText, [CmdResultDetails.Strings[0]]);
end;

procedure TIdSNPP.Quit;
begin
 //
end;

procedure TIdSNPP.Reset;
begin
  Writeln('RESET');
end;

function TIdSNPP.SendMessage(APagerId, AMsg : String): String;
var
  Resp : String;
begin
  try
    if (APagerId <> '') and (AMsg <> '') then
    begin
      if Pager(APagerID) then
      begin
        if SNPPMsg(AMsg) then
          Writeln('SEND');
        Resp := Copy(CmdResult, 5, Maxint);
        if GetResponse([]) = 250 then
          Result := 'Message Sent';
        Disconnect;
      end
      else
        raise EIdSNPPConnectionRefused.CreateError(502,Resp);
    end;
  finally
  end;
end;

function TIdSNPP.SNPPMsg(AMsg: String): Boolean;
begin
  Result := False;
  Writeln('MESS '+AMsg);
  //Resp := Copy(CmdResult, 5, Maxint);
  if GetResponse([]) = 250 then
    Result := True
  else
    DoStatus(hsStatusText,  [CmdResultDetails.Strings[0]]);
end;

end.
