unit IdRFCReply;

interface

uses
  Classes;

type
  TIdRFCReply = class(TPersistent)
  protected
    FNumericCode: integer;
    FText: TStrings;
    //
    procedure AssignTo(ADest: TPersistent); override;
    procedure SetText(const AValue: TStrings);
  public
    procedure Clear;
    constructor Create; virtual;
    destructor Destroy; override;
    function GenerateReply: string;
    function ReplyExists: Boolean;
    procedure SetReply(const ANumericCode: Integer; const AText: string);
  published
    property NumericCode: Integer read FNumericCode write FNumericCode;
    property Text: TStrings read FText write SetText;
  end;

implementation

uses
  IdGlobal,
  SysUtils;

{ TIdRFCReply }

procedure TIdRFCReply.AssignTo(ADest: TPersistent);
var
  LDest: TIdRFCReply;
begin
  if ADest is TIdRFCReply then begin
    LDest := TIdRFCReply(ADest);
    LDest.Clear;
    LDest.NumericCode := NumericCode;
    LDest.Text.Assign(Text);
  end else begin
    inherited;
  end;
end;

procedure TIdRFCReply.Clear;
begin
  FNumericCode := 0;
  FText.Clear;
end;

constructor TIdRFCReply.Create;
begin
  inherited;
  FText := TStringList.Create;
  Clear;
end;

destructor TIdRFCReply.Destroy;
begin
  FreeAndNil(FText);
  inherited;
end;

function TIdRFCReply.GenerateReply: string;
var
  i: Integer;
begin
  Result := '';
  if NumericCode > 0 then begin
    Result := '';
    if FText.Count > 0 then begin
      for i := 0 to FText.Count - 1 do begin
        if i < FText.Count - 1 then begin
          Result := Result + IntToStr(NumericCode) + '-' + FText[i] + EOL;
        end else begin
          Result := Result + IntToStr(NumericCode) + ' ' + FText[i] + EOL;
        end;
      end;
    end else begin
      Result := Result + IntToStr(NumericCode) + EOL;
    end;
  end else if FText.Count > 0 then begin
    Result := FText.Text;
  end;
end;

function TIdRFCReply.ReplyExists: Boolean;
begin
  Result := (NumericCode > 0) or (FText.Count > 0);
end;

procedure TIdRFCReply.SetReply(const ANumericCode: Integer; const AText: string);
begin
  FNumericCode := ANumericCode;
  FText.Text := AText;
end;

procedure TIdRFCReply.SetText(const AValue: TStrings);
begin
  FText.Assign(AValue);
end;

end.
