{
 Indy POP3 Server

 Original Programmer: Luke Croteau
 No Copyright. Code is given to the Indy Pit Crew.

 Quick Notes:
    A few of the methods return a default message number if a number isn't entered.
    The LIST, DELE, RETR, UIDL, and TOP command will return a -1 in the parameters
    if the value isn't specified by the client.
    Some functions require this capability. For example, the LIST command can operate
    either by a certain message number or a with no arguments. See RFC1939 for details.

 Revision History:
 26-Dec-2000:
    -Andrew Neillans found a bug on line 157. Originally it was
     If Assigned(OnCommandLIST) then OnCommandRETR(...).
     Changed to OnCommandLIST(...). Thanks Andrew!
 29-Oct-2000:
    -I discovered I really shouldn't program at night.
     The error wasn't that it shouldn't be Succ (Because it should), but
     because I forgot to implement LIST
 27-Oct-2000:
    -Fixed a dumb bug. Originally coded command parsing as Succ(PosInStrArray)
     Should be just PosInStrArray b/c it is not a dynamic array. The bounds
     are constant.
 25-Oct-2000:
    -Created Unit.
    -Created new POP3 Server Component according to RFC 1939
}
unit IdPOP3Server;

interface

uses
  Classes,
  IdAssignedNumbers,
  IdTCPServer;

type
  TIdPOP3ServerState = (POPStateName, POPStateTransaction, POPStateUpdate);

  TIdPOP3NoParamEvent = procedure (AThread :TIdPeerThread) of object;
  TIdPOP3MessageNumberEvent = procedure (AThread :TIdPeerThread; AMessageNum :Integer) of object;
  TIdPOP3USERCommandEvent = procedure (AThread :TIdPeerThread; AUserName :String) of object;
  TIdPOP3PASSCommandEvent = procedure (AThread :TIdPeerThread; APassword :String) of object;
  TIdPOP3APOPCommandEvent = procedure (AThread :TIdPeerThread; AMailboxID :String; ADigest :String) of object;
  TIdPOP3TOPCommandEvent = procedure (AThread :TIdPeerThread; AMessageNum :Integer; ANumLines :Integer) of object;

  TIdPOP3Server = class(TIdTcpServer)
  protected
    fState :TIdPOP3ServerState;
    fOnCommandUSER :TIdPOP3USERCommandEvent;
    fOnCommandPASS :TIdPOP3PASSCommandEvent;
    fOnCommandLIST :TIdPOP3MessageNumberEvent;
    fOnCommandRETR :TIdPOP3MessageNumberEvent;
    fOnCommandDELE :TIdPOP3MessageNumberEvent;
    fOnCommandQUIT :TIdPOP3NoParamEvent;
    fOnCommandAPOP :TIdPOP3APOPCommandEvent;
    fOnCommandSTAT :TIdPOP3NoParamEvent;
    fOnCommandNOOP :TIdPOP3NoParamEvent;
    fOnCommandRSET :TIdPOP3NoParamEvent;
    fOnCommandTOP  :TIdPOP3TOPCommandEvent;
    fOnCommandUIDL :TIdPOP3MessageNumberEvent;

    function DoExecute(AThread :TIdPeerThread):Boolean; override;
  public
    constructor Create(AOwner :TComponent); override;
  published
    property State :TIdPOP3ServerState read fState write fState;
    property OnCommandUSER :TIdPOP3USERCommandEvent read fOnCommandUSER write fOnCommandUSER;
    property OnCommandPASS :TIdPOP3PASSCommandEvent read fOnCommandPASS write fOnCommandPASS;
    property OnCommandLIST :TIdPOP3MessageNumberEvent read fOnCommandLIST write fOnCommandLIST;
    property OnCommandRETR :TIdPOP3MessageNumberEvent read fOnCommandRETR write fOnCommandRETR;
    property OnCommandDELE :TIdPOP3MessageNumberEvent read fOnCommandDELE write fOnCommandDELE;
    property OnCommandQUIT :TIdPOP3NoParamEvent read fOnCommandQUIT write fOnCommandQUIT;
    property OnCommandAPOP :TIdPOP3APOPCommandEvent read fOnCommandAPOP write fOnCommandAPOP;
    property OnCommandSTAT :TIdPOP3NoParamEvent read fOnCommandSTAT write fOnCommandSTAT;
    property OnCommandNOOP :TIdPOP3NoParamEvent read fOnCommandNOOP write fOnCommandNOOP;
    property OnCommandRSET :TIdPOP3NoParamEvent read fOnCommandRSET write fOnCommandRSET;
    property OnCommandTOP  :TIdPOP3TOPCommandEvent read fOnCommandTOP write fOnCommandTOP;
    property OnCommandUIDL :TIdPOP3MessageNumberEvent read fOnCommandUIDL write fOnCommandUIDL;
  end;

implementation

uses
  SysUtils,
  IdResourceStrings,
  IdGlobal;

const
  KnownCommands :Array [1..12] of String =
   ('USER',  
    'PASS',
    'LIST',
    'RETR',
    'DELE',
    'QUIT',
    'APOP',
    'STAT',
    'NOOP',
    'RSET',
    'TOP',
    'UIDL'
   );

{TIdPOP3Server}
constructor TIdPOP3Server.Create(AOwner :TComponent);
begin
  inherited;
  DefaultPort := IDPORT_POP3;
end;

function TIdPOP3Server.DoExecute(AThread :TIdPeerThread):Boolean;
var
  Cmd,
  Cmd2,
  Cmd3,
  input :String;
  nNumber,
  nLines  :Integer;

  procedure NotHandled();
  begin
    AThread.Connection.WriteLn('-ERR '+ RSPOP3SvrNotHandled + Cmd);
  end;
begin
  Result := True;
  State := POPStateName;
  with AThread.Connection do
  begin
    while Connected do
    begin
      input := ReadLn();
      Cmd := Fetch(input);

      case Succ(PosInStrArray(AnsiUpperCase(Cmd), KnownCommands)) of
      1: // USER
        begin
          Cmd2 := Fetch(input);
          if Assigned(OnCommandUSER) then
            OnCommandUSER(AThread, Cmd2)
          else
            NotHandled();
        end;
      2: // PASS
        begin
          Cmd2 := Fetch(input);
          if Assigned(OnCommandPASS) then
            OnCommandPASS(AThread, Cmd2)
          else
            NotHandled();
        end;
      3: // LIST
        begin
          nNumber := StrToIntDef(Fetch(input), -1);
          if Assigned(OnCommandLIST) then
            OnCommandLIST(AThread, nNumber)
          else
            NotHandled();
        end;
      4: // RETR
        begin
          nNumber := StrToIntDef(Fetch(input), -1);
          if Assigned(OnCommandRETR) then
            OnCommandRETR(AThread, nNumber)
          else
            NotHandled();
        end;
      5:  // DELE
        begin
          nNumber := StrToIntDef(Fetch(input), -1);
          if Assigned(OnCommandDELE) then
            OnCommandDELE(AThread, nNumber)
          else
            NotHandled();
        end;
      6:  // QUIT
        begin
          if Assigned(OnCommandQUIT) then
            OnCommandQUIT(AThread)
          else
            NotHandled();
        end;
      7:  // APOP
        begin
          Cmd2 := Fetch(input);
          Cmd3 := Fetch(input);
          if Assigned(OnCommandAPOP) then
            OnCommandAPOP(AThread, Cmd2, Cmd3)
          else
            NotHandled();
        end;
      8:  // STAT
        begin
          if Assigned(OnCommandSTAT) then
            OnCommandSTAT(AThread)
          else
            NotHandled();
        end;
      9:  // NOOP
        begin
          if Assigned(OnCommandNOOP) then
            OnCommandNOOP(AThread)
          else
            NotHandled();
        end;
      10:  // RSET
        begin
          if Assigned(OnCommandRSET) then
            OnCommandRSET(AThread)
          else
            NotHandled();
        end;
      11: // TOP
        begin
          nNumber := StrToIntDef(Fetch(input), -1);
          nLines := StrToIntDef(Fetch(input), -1);
          if Assigned(OnCommandTOP) then
            OnCommandTOP(AThread, nNumber, nLines)
          else
            NotHandled();
        end;
      12: // UIDL
        begin
          nNumber := StrToIntDef(Fetch(input), -1);
          if Assigned(OnCommandUIDL) then
            OnCommandUIDL(AThread, nNumber)
          else
            NotHandled();
        end;
      else
        NotHandled();
      end; // case PosInStrArray(.....
    end; // While Connected
  end; // with AThread.Connection do
end;

end.
