unit IdMappedPortTCP;

interface

uses
  Classes, IdTCPClient, IdTCPServer;

type
  TIdMappedPortTCPData = class
  public
    OutboundClient: TIdTCPClient;
    ReadList: TList;
    //
    constructor Create;
    destructor Destroy; override;
  end;

  TBeforeClientConnectEvent = procedure(ASender: TComponent; AThread: TIdPeerThread;
   AClient: TIdTCPClient) of object;

  TIdMappedPortTCP = class(TIdTCPServer)
  protected
    FMappedPort: integer;
    FMappedHost: string;
    FOnBeforeClientConnect: TBeforeClientConnectEvent;
    //
    procedure DoConnect(AThread : TIdPeerThread); override;
    function DoExecute(AThread : TIdPeerThread): boolean; override;
  public
  published
    property MappedHost: string read FMappedHost write FMappedHost;
    property MappedPort: integer read FMappedPort write FMappedPort;
    property OnBeforeClientConnect: TBeforeClientConnectEvent read FOnBeforeClientConnect
     write FOnBeforeClientConnect;
  end;

implementation

uses
  IdGlobal, IdStack, IdIOHandlerSocket,
  SysUtils;

procedure TIdMappedPortTCP.DoConnect(AThread: TIdPeerThread);
begin
  inherited;
  AThread.Data := TIdMappedPortTCPData.Create;
  with TIdMappedPortTCPData(AThread.Data) do begin
    OutboundClient := TIdTCPClient.Create(nil);
    with OutboundClient do begin
      Port := MappedPort;
      Host := MappedHost;
      if Assigned(FOnBeforeClientConnect) then begin
        FOnBeforeClientConnect(Self, AThread, OutboundClient);
      end;
      {TODO: Handle connect failures}
      Connect;
    end;
  end;
end;

function TIdMappedPortTCP.DoExecute(AThread : TIdPeerThread): boolean;
var
  LConnectionHandle: TObject;
  LData: TIdMappedPortTCPData;
  LOutBoundHandle: TObject;
begin
  Result := True;
  LData := TIdMappedPortTCPData(AThread.Data);
  try
    with LData.ReadList do begin
      Clear;
      LConnectionHandle
       := TObject((AThread.Connection.IOHandler as TIdIOHandlerSocket).Binding.Handle);
      LOutBoundHandle
       := TObject((LData.OutboundClient.IOHandler as TIdIOHandlerSocket).Binding.Handle);
      Add(LConnectionHandle);
      Add(LOutBoundHandle);
      if GStack.WSSelect(LData.ReadList, nil, nil, IdTimeoutInfinite) > 0 then begin
        //TODO: Make a select list that also has a function to check of handles
        if IndexOf(LConnectionHandle) > -1 then begin
          LData.OutboundClient.Write(AThread.Connection.CurrentReadBuffer);
        end;
        if IndexOf(LOutBoundHandle) > -1 then begin
          AThread.Connection.Write(LData.OutboundClient.CurrentReadBuffer);
        end;
      end;
    end;
  finally
    if not LData.OutboundClient.Connected then begin
      AThread.Connection.Disconnect;
    end;
  end;
end;

{ TIdMappedPortTCPData }

constructor TIdMappedPortTCPData.Create;
begin
  ReadList := TList.Create;
end;

destructor TIdMappedPortTCPData.Destroy;
begin
  FreeAndNil(ReadList);
  FreeAndNil(OutboundClient);
  inherited;
end;

end.