unit IdIOHandlerEncryptedSocket;

interface

Uses
  IdIOHandlerSocket;

Type
  TIdIOHandlerEncryptedSocket = class(TIdIOHandlerSocket)
  protected
    fPassThrough: Boolean;
    //
    function RecvEnc(var ABuf; ALen: integer): integer; virtual; abstract;
    function SendEnc(var ABuf; ALen: integer): integer; virtual; abstract;
    procedure SetPassThrough(const Value: Boolean);

    procedure OpenEncodedConnection; virtual;
  public
    function Recv(var ABuf; ALen: integer): integer; override;
    function Send(var ABuf; ALen: integer): integer; override;
  published
    property PassThrough: Boolean read fPassThrough write SetPassThrough;
  end;

implementation

{ TIdIOHandlerEncryptedSocket }

procedure TIdIOHandlerEncryptedSocket.OpenEncodedConnection;
begin
  //
end;

function TIdIOHandlerEncryptedSocket.Recv(var ABuf;
  ALen: integer): integer;
begin
  if fPassThrough then begin
    result := inherited Recv(ABuf, ALen);
  end
  else begin
    result := RecvEnc(ABuf, ALen);
  end;
end;

function TIdIOHandlerEncryptedSocket.Send(var ABuf;
  ALen: integer): integer;
begin
  if fPassThrough then begin
    result := inherited Send(ABuf, ALen);
  end
  else begin
    result := SendEnc(ABuf, ALen);
  end;
end;

procedure TIdIOHandlerEncryptedSocket.SetPassThrough(const Value: Boolean);
begin
  if not Value then
  begin
    if Connected then begin
      OpenEncodedConnection;
    end;
  end;
  fPassThrough := Value;
end;

end.
