unit IdHashElf;

interface

uses
  Classes,
  IdHash;

type
  TIdHashElf = class(TIdHash32)
  public
    function HashValue(AStream: TStream): LongWord; override;
  end;

implementation

{ TIdHashElf }

function TIdHashElf.HashValue(AStream: TStream): LongWord;
var
	i: LongWord;
  j: byte;
begin
	Result := 0;
  AStream.Position := 0;
  while AStream.Position < AStream.Size do begin
    AStream.ReadBuffer(j, SizeOf(j));
		Result := (Result shl 4) + j;
		i := Result and $F000000;
		if i <> 0 then begin
    	Result := Result xor (i Shr 24);
    end;
		Result := Result and not i;
	end;
end;

end.
