unit IdHash;

interface

uses
  Classes;

type
  TIdHash16 = class(TObject)
  public
    function HashValue(ASrc: string): Word; overload;
    function HashValue(AStream: TStream): Word; overload; virtual; abstract;
  end;

  TIdHash32 = class(TObject)
  public
    function HashValue(ASrc: string): LongWord; overload;
    function HashValue(AStream: TStream): LongWord; overload; virtual; abstract;
  end;

  T4x4LongWordRecord = array [0..3] of LongWord;

  TIdHash128 = class(TObject)
  public
    function HashValue(ASrc: string): T4x4LongWordRecord; overload;
    function HashValue(AStream: TStream): T4x4LongWordRecord; overload; virtual; abstract;
  end;

implementation

uses
  IdGlobal,
  SysUtils;

{ TIdHash32 }

function TIdHash32.HashValue(ASrc: string): LongWord;
var
  LStream: TStringStream;
begin
  LStream := TStringStream.Create(ASrc); try
    Result := HashValue(LStream);
  finally FreeAndNil(LStream); end;
end;

{ TIdHash16 }

function TIdHash16.HashValue(ASrc: string): Word;
var
  LStream: TStringStream;
begin
  LStream := TStringStream.Create(ASrc); try
    Result := HashValue(LStream);
  finally FreeAndNil(LStream); end;
end;

{ TIdHash128 }

function TIdHash128.HashValue(ASrc: string): T4x4LongWordRecord; 
var
  LStream: TStringStream;
begin
  LStream := TStringStream.Create(ASrc); try
    Result := HashValue(LStream);
  finally FreeAndNil(LStream); end;
end;

end.
