{

  Implementation of the NTLM authentication as specified in
  http://www.innovation.ch/java/ntlm.html with some fixes

  Author: Doychin Bondzhev (doychin@dsoft-bg.com)
  Copyright: (c) Chad Z. Hower and The Winshoes Working Group.

}
unit IdAuthenticationNTLM;

interface

Uses
  Classes, SysUtils,
  IdAuthentication;

Type
  TIdNTLMAuthentication = class(TIdAuthentication)
  protected
    FNTLMInfo: String;

    function DoNext: TIdAuthWhatsNext; override;
  public
    constructor Create; override;
    function Authentication: String; override;
    function KeepAlive: Boolean; override;
    procedure Reset; override;
  end;

implementation

Uses
  IdGlobal,
  IdException,
  IdCoderMIME,
  IdSSLOpenSSLHeaders,
  IdNTLM;

{ TIdNTLMAuthentication }

constructor TIdNTLMAuthentication.Create;
begin
  inherited Create;
  // Load Open SSL Library
  if not IdSSLOpenSSLHeaders.Load then
  begin
    Unload;
    Abort;
  end;
end;

function TIdNTLMAuthentication.DoNext: TIdAuthWhatsNext;
begin
  result := wnDoRequest;

  case FStatus of
    0:
      begin
        result := wnDoRequest;
        FStatus := 1;
      end;
    1:
      begin
        FStatus := 2;
        if (Length(Username) > 0) and (Length(Password) > 0) then
        begin
          result := wnDoRequest;
        end
        else begin
          result := wnAskTheProgram;
        end;
      end;
    3:
      begin
        FStatus := 4;
        result := wnDoRequest;
      end;
    4:
      begin
        Reset;
        result := wnFail;
      end;
  end;
end;

function TIdNTLMAuthentication.Authentication: String;
Var
  S: String;
  Type2: type_2_message_header;
  LDomain: String;
  LHost: String;
begin
  result := '';
  case FStatus of
    1:
      begin
        LHost := IndyGetHostName;

        LDomain := ' ';

        result := 'NTLM ' + BuildType1Message(LDomain, LHost);
        FNTLMInfo := '';
      end;
    2:
      begin
        if Length(FNTLMInfo) = 0 then
        begin
          FNTLMInfo := ReadAuthInfo('NTLM');
          Fetch(FNTLMInfo);
        end;

        if Length(FNTLMInfo) = 0 then
        begin
          Reset;
          Abort;
        end;

        S := TIdDecoderMIME.DecodeString(FNTLMInfo);
        move(S[1], type2, sizeof(type2));
        Delete(S, 1, sizeof(type2));

        S := Type2.Nonce;

        S := BuildType3Message(LDomain, LHost, Username, Password, Type2.Nonce);
        result := 'NTLM ' + S;

        FStatus := 3;
      end;
  end;
end;

procedure TIdNTLMAuthentication.Reset;
begin
  inherited Reset;
  FStatus := 1;
end;

function TIdNTLMAuthentication.KeepAlive: Boolean;
begin
  result := true;
end;

initialization
  RegisterAuthenticationMethod('NTLM', TIdNTLMAuthentication);
end.
