unit IdAuthenticationManager;

interface

Uses
  Classes, SysUtils, IdAuthentication, IdURI, IdGlobal;

Type
  TIdAuthenticationItem = class(TCollectionItem)
  protected
    FURI: TIdURI;
    FParams: TStringList;
    procedure SetParams(const Value: TStringList);
    procedure SetURI(const Value: TIdURI);
  public
    constructor Create(ACollection: TCOllection); override;
    destructor Destroy; override;

    property URL: TIdURI read FURI write SetURI;
    property Params: TStringList read FParams write SetParams;
  end;

  TIdAuthenticationManager = class(TCollection)
  protected
    function GetAuthItem(AIndex: Integer): TIdAuthenticationItem;
    procedure SetAuthItem(AIndex: Integer;
      const Value: TIdAuthenticationItem);
  public
    constructor Create;

    function Add: TIdAuthenticationItem;

    property Items[AIndex: Integer]: TIdAuthenticationItem read GetAuthItem write SetAuthItem;
  end;

implementation

{ TIdAuthenticationManager }

function TIdAuthenticationManager.Add: TIdAuthenticationItem;
begin
  result := TIdAuthenticationItem.Create(self);
end;

constructor TIdAuthenticationManager.Create;
begin
  inherited Create(TIdAuthenticationItem);
end;

function TIdAuthenticationManager.GetAuthItem(
  AIndex: Integer): TIdAuthenticationItem;
begin
  result := TIdAuthenticationItem(inherited Items[AIndex]);
end;

procedure TIdAuthenticationManager.SetAuthItem(AIndex: Integer;
  const Value: TIdAuthenticationItem);
begin
  if Items[AIndex] <> nil then begin
    Items[AIndex].Assign(Value);
  end;
end;

{ TIdAuthenticationItem }

constructor TIdAuthenticationItem.Create(ACollection: TCOllection);
begin
  inherited Create(ACollection);

  FURI := TIdURI.Create;
  FParams := TStringList.Create;
end;

destructor TIdAuthenticationItem.Destroy;
begin
  FreeAndNil(FURI);
  FreeAndNil(FParams);
  inherited Destroy;
end;

procedure TIdAuthenticationItem.SetParams(const Value: TStringList);
begin
  FParams.Assign(Value);
end;

procedure TIdAuthenticationItem.SetURI(const Value: TIdURI);
begin
  FURI.URI := Value.URI;
end;

end.
